//////////////////////////////////////////////////////////////////////////////
//
//   WinSniff 
//   The network packet sniffer for windows.
//
//   Author  : Nagareshwar Y Talekar.
//	 Contact : tnagareshwar@gmail.com
//	 Date    : 15-6-2004.
//
//
//   History 
//   ================
//
//   Ver 1.0  15th June 2004  First public release of WinSniff
//
//   Ver 1.5  8th April 2007  GUI modification and new look & feel.
//
//   Ver 1.6  17th June 2007  GUI modification and embeded the manifest file
//                            Changed code to make it compatible with VS2005.
//
//////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "CapturePacket.h"
#include "Protocol.h"
#include "CapturePacketDlg.h"
#include "SelectDlg.h"


#include <pcap.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCapturePacketDlg dialog

CCapturePacketDlg::CCapturePacketDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCapturePacketDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCapturePacketDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCapturePacketDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCapturePacketDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCapturePacketDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_NOTIFY(NM_CLICK,IDC_LIST1,OnRowSelect)
	ON_NOTIFY(NM_DBLCLK,IDC_TREE1,OnTreeSelect)
	
	//Hot Key
	ON_MESSAGE(WM_HOTKEY,OnHotkey)

	//File Menu
	ON_COMMAND(11,OnOpenFrame)
	ON_COMMAND(12,OnSaveFrame)
	ON_COMMAND(13,OnCancel)
	
	//Capture Menu 
	ON_COMMAND(21,OnStartCapture)
	ON_COMMAND(22,OnStopCapture)
	
	//Filter Menu
	ON_COMMAND(31,OnFilterProtocol)
	ON_COMMAND(32,OnFilterPort)
	ON_COMMAND(33,OnFilterIPAddress)
	ON_COMMAND(34,OnFilterCustom)

	
	//View Menu
	ON_COMMAND(51,OnHide)
	
	//Help Menu
	ON_COMMAND(41,OnAbout)
	
	//ON_COMMAND(IDC_BUTTON2,ApplyFilter)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCapturePacketDlg message handlers

BOOL CCapturePacketDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	//Intialize variables....
	packetcount=0;
	filter="";
	portfilter="";
	protofilter="";
	ipfilter="";
	IsVisible=TRUE;


		
	fprotocol=new FProtocol(NULL);
	fport=new FPort(NULL);
	fipaddress=new FIPAddress(NULL);
	fcustom=new FCustom(NULL);

	

    sfile=new CStdioFile();
   	
	


	menu=(CMenu*)this->GetMenu();
	datalist=(CListBox *) this->GetDlgItem(IDC_LIST2);
	layertree=(CTreeCtrl*) this->GetDlgItem(IDC_TREE1);
	list=(CListCtrl *)this->GetDlgItem(IDC_LIST1);
	
	

	datafont.CreateFont(16,10,0,0,FW_REGULAR,0,0,0,DEFAULT_CHARSET,0,0,0,0,"Courier New");
	datalist->SetFont(&datafont);
	datalist->SetHorizontalExtent(740);
	
	InitListCtrl();

	menu->EnableMenuItem(22,MF_GRAYED);
	menu->EnableMenuItem(23,MF_GRAYED);
	menu->EnableMenuItem(24,MF_GRAYED);

	// Disable all filters...
	menu->EnableMenuItem(31,MF_GRAYED);
	menu->EnableMenuItem(32,MF_GRAYED);
	menu->EnableMenuItem(33,MF_GRAYED);
	menu->EnableMenuItem(34,MF_GRAYED);

	
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	sniff=new Sniffer();
	if(sniff->GetDeviceList()==0)
	{
	menu->EnableMenuItem(21,MF_GRAYED);
	MessageBox("No network adapters are present");
	}	
	
	//Set tool tip text...
	treetip.Create(this,TTS_ALWAYSTIP );
	treetip.SetDelayTime(50);
	treetip.AddTool(layertree,"Double click on the header");
	
	layertree->SetToolTips(&treetip);



	
	//Register the hot key
	m_hotkeyid=501;
    RegisterHotKey(GetSafeHwnd(),m_hotkeyid,MOD_ALT,VK_F5);
	

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCapturePacketDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CCapturePacketDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}



void CCapturePacketDlg::OnRowSelect(NMHDR* pNMHDR, LRESULT* pResult)
{
POSITION pos;
int index;

	pos=list->GetFirstSelectedItemPosition();
	
	if(pos==NULL) //No item selected...
	return;

	index=list->GetNextSelectedItem(pos);
	
	DisplayFrame(index);
	
}





void CCapturePacketDlg::OnTreeSelect(NMHDR* pNMHDR, LRESULT* pResult)
{
HTREEITEM selitem,paritem;	
	selitem=layertree->GetSelectedItem();
	if(selitem==NULL)
	return;

	paritem=layertree->GetParentItem(selitem);
		
	if(paritem!=NULL)
	return;

	//Continue if the selected item is the root item
	CString name=layertree->GetItemText(selitem);

	//Complete Frame
	if(name.Find("Frame",0)!=-1)
	{
		DisplayData(frame,framesize);
		return;
	}
	
	
	//Ethernet layer
	if(name.Find("Ethernet",0)!=-1)
	{
		DisplayData(frame,ETHER_LENGTH);
		return;
	}
	
	//ARP layer
	if(name.Find("ARP",0)!=-1)
	{
		DisplayData(frame+ETHER_LENGTH,ARP_LENGTH);
		return;
	}
	
	//IP layer
	if(name.Find("IP",0)!=-1)
	{
		DisplayData(frame+ETHER_LENGTH,IP_LENGTH);
		return;
	}
	
	//TCP layer
	if(name.Find("TCP",0)!=-1)
	{
		DisplayData(frame+ETHER_LENGTH+IP_LENGTH,TCP_LENGTH);
		return;
	}
	
	//UDP layer
	if(name.Find("UDP",0)!=-1)
	{
		DisplayData(frame+ETHER_LENGTH+IP_LENGTH,UDP_LENGTH);
		return;
	}
	
	//ICMP layer
	if(name.Find("ICMP",0)!=-1)
	{
		DisplayData(frame+ETHER_LENGTH+IP_LENGTH,ICMP_LENGTH);
		return;
	}
	
	//IGMP layer
	if(name.Find("IGMP",0)!=-1)
	{
		DisplayData(frame+ETHER_LENGTH+IP_LENGTH,IGMP_LENGTH);
		return;
	}
	
	
	
	//Data layer
	if(name.Find("Data",0)!=-1)
	{
		DisplayData(frame+dataoff,datasize);
		return;
	}
	
	// Check for some unhandled/new layer
	if(name.Find("Unknown",0)!=-1)
	{
		DisplayData(frame,-1);   //Clear the data....
		return;
	}
	

}




void CCapturePacketDlg::InitListCtrl()
{
		
	list->SetExtendedStyle(LVS_EX_FULLROWSELECT); 
	
	list->InsertColumn(0,"No",LVCFMT_LEFT,80);
	list->InsertColumn(1,"Time",LVCFMT_LEFT,70);
	list->InsertColumn(2,"Length",LVCFMT_LEFT,60);
	list->InsertColumn(3,"Frame Type",LVCFMT_LEFT,90);
	list->InsertColumn(4,"Protocol",LVCFMT_LEFT,80);
	list->InsertColumn(5,"SAddress",LVCFMT_LEFT,120);
	list->InsertColumn(6,"SPort",LVCFMT_LEFT,50);
	list->InsertColumn(7,"DAddress",LVCFMT_LEFT,120);
	list->InsertColumn(8,"DPort",LVCFMT_LEFT,50);
	list->InsertColumn(9,"Information",LVCFMT_LEFT,300);
}




LRESULT CCapturePacketDlg::OnHotkey(WPARAM wParam, LPARAM lParam)
{
	if(IsVisible)
	{
	this->ShowWindow(SW_HIDE);
	IsVisible=FALSE;
	}
	else
	{
	this->ShowWindow(SW_SHOWNORMAL);
	this->SetFocus();
	IsVisible=TRUE;
	}

	return TRUE;
}


void CCapturePacketDlg::OnOpenFrame()
{
CFileDialog fd(1,0,0,0,"Text Files(*.txt)|*.txt|All Files|*.*||");
CString line;
BOOL ret;
int index,length;
char buffer[MAX_PACKET_SIZE];
CStdioFile tfile;
	
	
		if(fd.DoModal()==IDOK)
		{
		

			ret=tfile.Open(fd.GetPathName(),CFile::modeRead);

			if(ret==FALSE)
			{
			MessageBox("Unable to open the specified file");
			return;
			}
		
			tfile.ReadString(line);
			index=line.Find("Frame Length");
						
			if(index==-1)
			{
			MessageBox("Unrecognized format ");
			tfile.Close();
		 	return;
			}
			
			index=line.Find('=');
			
			if(index==-1)
			{
			MessageBox("Unrecognized format ");
			tfile.Close();
			return;
			}
			
			// Get the length of frame...
			index++;
			sscanf(((LPCTSTR)line)+index,"%d",&length);
			
			tfile.ReadString(line);   //dummy line...
			
			ret=tfile.Read(buffer,length); //
			
			if(ret!=length)
			{
			MessageBox("Frame data is corrupted...");
			tfile.Close();
		 	return;
			}
			
			//Read successfully....
			framesize=length;
			memcpy(frame,buffer,length);
			frameno=-1;
			DisplayData(frame,framesize);
			DisplayTree();
			
			tfile.Close();
			
		}


}

void CCapturePacketDlg::OnSaveFrame()
{
CFileDialog fd(0,0,0,0,"Text Files(*.txt)|*.txt|All Files|*.*||");
CString filename,ext;
CStdioFile tfile;
u_char *pdata;
char str[500],line[400],hex[100];
int linecount=0,limit,length,slen;
	

	if(datalist->GetCount()==0)
	{
	MessageBox("Please select the frame..");
	return;
	}

	fd.m_ofn.lpstrTitle="Save File";



	if(fd.DoModal()==IDOK)
	{
		
		filename=fd.GetPathName();
		ext=fd.GetFileExt();
		
		if(ext.IsEmpty())
		filename=filename+".txt";
	

		//Create the new file....
		tfile.Open(filename,CFile::modeCreate | CFile::modeWrite| CFile::typeBinary);
		
		sprintf(str,"Frame Length=%d",framesize);
		tfile.WriteString(str);

		sprintf(str,"\r\nFrame Data ...\r\n");
		tfile.WriteString(str);

		tfile.Write(frame,framesize);

		length=framesize;
		
		sprintf(str,"\r\n\r\nHex display of Frame");
		tfile.WriteString(str);

		
		while(length>0)
		{

			pdata=frame+linecount*16;

			limit=length<16?length:16;
			
			//print index
			sprintf(line,"\r\n 0x%.4x ",linecount*16);
						
			//print hex content (hex bytes)
			for(int i=0;i<limit;i++)
			{
				sprintf(hex,"%.2x ",pdata[i]);
				strcat(line,hex);
			}			
	
			if(limit<16)
			{
			sprintf(hex,"%*s",(16-limit)*3," ");
			strcat(line,hex);
			}
			
			slen=strlen(line);
			int j;
			for (j=0; j<limit; j++)
			line[slen+j]=isprint(pdata[j])?pdata[j]:'.';

			line[slen+j]=0;
		
			tfile.WriteString(line);
			
			linecount++;
			length=length-16;
		}
	
		WriteToFile(&tfile);
		tfile.Close();
	}


}

void CCapturePacketDlg::WriteToFile(CStdioFile *tfile) 
{
eth_header *eh;
ip_header *iph;
tcp_header *tcph;
udp_header *udph;
icmp_header *icmph;
igmp_header *igmph;

char str[300];
int ip_hlen;


	tfile->WriteString("\r\n\r\n[ Ethernet Header ]\r\n");
	eh=(eth_header*)frame;
	DisplayEthernetHeader(eh,tfile);

	
	
	//Get ARP header
	if(ntohs(eh->type)==0x0806)
	{
		tfile->WriteString("\r\n\r\n[ ARP Header ]\r\n");
		DisplayARPHeader((arp_header*) (frame+ETHER_LENGTH) ,tfile);
	return;
	}
	
	//Reject frames other than IP/ARP frames....
	if(ntohs(eh->type)!=0x0800)
	return;

	
	//Get Internet Header
	tfile->WriteString("\r\n\r\n[ IP Header ]\r\n");
	iph=(ip_header*)(frame+ETHER_LENGTH);
	DisplayIPHeader(iph,tfile);


	//Get the length of IP Header
	ip_hlen=(iph->ver_ihl & 0xf)<<2;
	
	switch(iph->proto)
	{
		case 1: //ICMP
			tfile->WriteString("\r\n\r\n[ ICMP Header ]\r\n");
			icmph=(icmp_header*)(frame+ETHER_LENGTH+ip_hlen);
			DisplayICMPHeader(icmph,tfile);	
			dataoff=ETHER_LENGTH+ip_hlen+ICMP_LENGTH;
			datasize=framesize-dataoff;
		break;
		
		case 2: //IGMP
			tfile->WriteString("\r\n\r\n[ IGMP Header ]\r\n");
			igmph=(igmp_header*)(frame+ETHER_LENGTH+ip_hlen);
			DisplayIGMPHeader(igmph,tfile);	
			dataoff=ETHER_LENGTH+ip_hlen+IGMP_LENGTH;
			datasize=framesize-dataoff;
		break;
		
	

		case 6: //TCP
			tfile->WriteString("\r\n\r\n[ TCP Header ]\r\n");
			tcph=(tcp_header*)(frame+ETHER_LENGTH+ip_hlen);
			DisplayTCPHeader(tcph,tfile);	
			dataoff=ETHER_LENGTH+ip_hlen+TCP_LENGTH;
			datasize=framesize-dataoff;

		break;

		case 17: //UDP
			tfile->WriteString("\r\n\r\n[ UDP Header ]\r\n");
			udph=(udp_header*)(frame+ETHER_LENGTH+ip_hlen);
			DisplayUDPHeader(udph,tfile);
			dataoff=ETHER_LENGTH+ip_hlen+UDP_LENGTH;
			datasize=framesize-dataoff;
		break;

		default:
			tfile->WriteString("\r\n\r\n[ Unknown Header ]\r\n");
			dataoff=ETHER_LENGTH+ip_hlen;
			datasize=framesize-dataoff;
		
		}

	
	if(datasize==0)
	return;
	
	//Display Data 
	tfile->WriteString("\r\n\r\n[ Data ]\r\n");
	sprintf(str,"Data length = %d ",datasize);
	tfile->WriteString(str);

}








void CCapturePacketDlg::OnCancel() 
{
	sniff->CloseDevice();
	UnregisterHotKey(GetSafeHwnd(),m_hotkeyid);
	CDialog::OnCancel();
}




/**
*    Displays the dialog box for selecting device for
*    capture and then start the capture...
*
*/

void CCapturePacketDlg::OnStartCapture()
{
SelectDlg sd(sniff);

	// If the device is selected then start capture...
	
	if(sniff->devcount>0)
	{

		
		if(sd.DoModal()==IDOK)
		{
			
			if(sniff->OpenDevice(sd.selindex))
			{
			
			// clear all....	
			list->DeleteAllItems();
			datalist->ResetContent();
			layertree->DeleteAllItems();
			
			menu->EnableMenuItem(21,MF_GRAYED);
			menu->EnableMenuItem(22,MF_ENABLED);


			// Enable all filters...
			menu->EnableMenuItem(31,MF_ENABLED);
			menu->EnableMenuItem(32,MF_ENABLED);
			menu->EnableMenuItem(33,MF_ENABLED);
			menu->EnableMenuItem(34,MF_ENABLED);

		
			packetcount=0;

			sfile->Open("packet.txt",CFile::modeWrite | CFile::modeCreate | CFile::shareDenyWrite | CFile::typeBinary);
	 		sniff->StartCapture(this);
	
			}	
		}
		
	}
	else
	{
	MessageBox("No capture devices are present");
	}

}



void CCapturePacketDlg::OnStopCapture()
{
	
	sniff->StopCapture();
	
	sfile->Close();
	
	menu->EnableMenuItem(21,MF_ENABLED);
	menu->EnableMenuItem(22,MF_GRAYED);

	// Disable all filters...
	menu->EnableMenuItem(31,MF_GRAYED);
	menu->EnableMenuItem(32,MF_GRAYED);
	menu->EnableMenuItem(33,MF_GRAYED);
	menu->EnableMenuItem(34,MF_GRAYED);

}







void CCapturePacketDlg::OnFilterProtocol()
{
BOOL ret;
	if(fprotocol->DoModal()==IDOK)
	{
	
	//Check for valid combination....
	if(  fprotocol->protocol.CompareNoCase("ICMP")==0 || fprotocol->protocol.CompareNoCase("IGMP")==0)
	{
		if(portfilter.IsEmpty()==FALSE)
		{
		MessageBox("Uncheck the PortFilter to Apply this Protocol Filter");
		return;
		}
	}
	protofilter=fprotocol->protocol;
	
	if(ipfilter.IsEmpty())
	filter=protofilter+portfilter;    //add together all the 3 filters...
	else
	filter=ipfilter+" and "+protofilter+portfilter;

	
	sniff->PauseCapture();
	ret=sniff->ApplyFilter((char *)(LPCTSTR)filter);
	sniff->ResumeCapture();
	
	if(ret==TRUE)
	MessageBox("Filter applied successfully");
	

	// Disable the custom filter if it is enabled..
	if(fcustom->IsEnable)
	{
		fcustom->IsEnable=FALSE;
		menu->CheckMenuItem(34,MF_UNCHECKED);
	}
	
	
	}
	
	//CHECK OR UNCHECK menu items..
	menu->CheckMenuItem(31,fprotocol->IsEnable?MF_CHECKED:MF_UNCHECKED);
	

}


void CCapturePacketDlg::OnFilterPort()
{
BOOL ret;

	//Check for valid combination....
	if(protofilter.CompareNoCase("ICMP")==0 || protofilter.CompareNoCase("IGMP")==0)
	{
		MessageBox("No port filter is associated with current protocol filter \r\n Remove the Protocol Filter to Apply Port Filter");
		return;
	}
		

	if(fport->DoModal()==IDOK)
	{
	
	portfilter=fport->portfilter;
	
	if(ipfilter.IsEmpty())
	filter=protofilter+portfilter;    //add together all the 3 filters...
	else
	filter=ipfilter+" and "+protofilter+portfilter;

	
	sniff->PauseCapture();
	ret=sniff->ApplyFilter((char *)(LPCTSTR)filter);
	sniff->ResumeCapture();
	
	
	if(ret==TRUE)
	MessageBox("Filter applied successfully");
	
	// Disable the custom filter if it is enabled..
	if(fcustom->IsEnable)
	{
		fcustom->IsEnable=FALSE;
		menu->CheckMenuItem(34,MF_UNCHECKED);
	}
	
	}

	//CHECK OR UNCHECK menu items..
	menu->CheckMenuItem(32,fport->IsEnable?MF_CHECKED:MF_UNCHECKED);
}


void CCapturePacketDlg::OnFilterIPAddress()
{
BOOL ret;
CString temp;
	if(fipaddress->DoModal()==IDOK)
	{
	
	ipfilter=fipaddress->ipfilter;
	
	temp=protofilter+portfilter;
	
	if(temp.IsEmpty())
	filter=ipfilter;   
	else
	{
		if(ipfilter.IsEmpty())
		filter=temp;
		else
		filter=ipfilter+" and "+temp;
	}
	
	sniff->PauseCapture();
	ret=sniff->ApplyFilter((char *)(LPCTSTR)filter);
	sniff->ResumeCapture();
		
	if(ret==TRUE)
	MessageBox("Filter applied successfully");
	
	
	// Disable the custom filter if it is enabled..
	if(fcustom->IsEnable)
	{
		fcustom->IsEnable=FALSE;
		menu->CheckMenuItem(34,MF_UNCHECKED);
	}
	
	}

	// CHECK OR UNCHECK menu items..
	menu->CheckMenuItem(33,fipaddress->IsEnable?MF_CHECKED:MF_UNCHECKED);

}


void CCapturePacketDlg::OnFilterCustom()
{
BOOL ret;

	if(fcustom->DoModal()==IDOK)
	{
	
	filter=fcustom->custfilter;

	// disable all other filters....
	ipfilter="";
	protofilter="";
	portfilter="";

	fipaddress->IsEnable=FALSE;
	fport->IsEnable=FALSE;
	fprotocol->IsEnable=FALSE;


	sniff->PauseCapture();
	ret=sniff->ApplyFilter((char *)(LPCTSTR)filter);
	sniff->ResumeCapture();
	
	
	if(ret==TRUE)
	MessageBox("Filter applied successfully");

	// Update the menu status....
	menu->CheckMenuItem(31,MF_UNCHECKED);
	menu->CheckMenuItem(32,MF_UNCHECKED);
	menu->CheckMenuItem(33,MF_UNCHECKED);
	menu->CheckMenuItem(34,MF_CHECKED);

	}




}


void CCapturePacketDlg::OnHide()
{
	if(IsVisible)
	{
		MessageBox(" Use   Alt+F5  key to make it visible." );
		this->ShowWindow(FALSE);
		IsVisible=FALSE;

	}

}

void CCapturePacketDlg::OnAbout()
{
CDialog about(IDD_DIALOG1);
about.DoModal();
}


void CCapturePacketDlg::DisplayFrame(int index)
{
long offset=0l;
BOOL retvalue;

//selected frame with starting index = 0
frameno=index;     

	/**
	*  Note : If the capture process is in progress then we cannot
	*         open the file packet.txt . Hence pause the capture 
	*         and close the file.Then open the file , get the data 
	*         and reopen the file in write mode , go to end and 
	*         resume the capture process.
	*/
	

	if(sniff->isStarted)
	{
	sniff->PauseCapture();	
	sfile->Close();
	}

	framesize=packetlength[frameno];

	// Calculate the offset
	for(int i=0;i<frameno;i++)
	offset+=packetlength[i];

	// Open the packet file in read mode...
	retvalue=sfile->Open("packet.txt",CFile::modeRead  | CFile::typeBinary );
	
		if(retvalue==FALSE)
		{
			
			MessageBox("Error occured while opening the file");

			sfile->Close();

			//  If capture process is in progress...
			//  then open the file again and continue..,
			if(sniff->isStarted)
			{
				sfile->Open("packet.txt",CFile::modeWrite | CFile::shareDenyWrite |CFile::typeBinary);
				sfile->SeekToEnd();
				sniff->ResumeCapture();
			}
			
			
			return;
		}
	
	sfile->Seek(offset,CFile::begin);

	sfile->Read(frame,framesize);
	sfile->Close();
	
	// If capturing is goinig on...then open the file and 
	// resume capture process

	if(sniff->isStarted)
	{
	// Now open the file in write mode and continue capture proces....
	sfile->Open("packet.txt",CFile::modeWrite | CFile::shareDenyWrite |CFile::typeBinary);
	sfile->SeekToEnd();
	sniff->ResumeCapture();

	}


 
//Now display data....

DisplayData(frame,framesize);
DisplayTree();



}


void CCapturePacketDlg::DisplayData(u_char *frame,int framesize)
{
//Now display data....
int length=framesize,linecount=0,limit,slen=0;
char line[400],hex[100];
u_char *pdata;
	
	
		//Delete previous content
		datalist->ResetContent();


		while(length>0)
		{

			pdata=frame+linecount*16;

			limit=length<16?length:16;
			
			//print index
			sprintf(line," 0x%.4x ",linecount*16);
						
			//print hex content (hex bytes)
			int i;
			for(i=0;i<limit;i++)
			{
				sprintf(hex,"%.2x ",pdata[i]);
				strcat(line,hex);
			}			
	
			if(limit<16)
			{
			sprintf(hex,"%*s",(16-limit)*3," ");
			strcat(line,hex);
			}
			
			slen=strlen(line);
			int j;
			for (j=0; j<limit; j++)
				line[slen+j]=isprint(pdata[j])?pdata[j]:'.';

			line[slen+j]=0;
		
			datalist->AddString(line);
						
			linecount++;
			length=length-16;
		}
			
}

void CCapturePacketDlg::DisplayTree()
{
eth_header *eh;
ip_header *iph;
tcp_header *tcph;
udp_header *udph;
icmp_header *icmph;
igmp_header *igmph;

char str[300];
int ip_hlen;
	
	layertree->DeleteAllItems();
	
	//Frame No
	if(frameno!=-1)
	sprintf(str,"Frame %d",frameno+1);
	else
	sprintf(str,"Saved Frame");
	
	layer1=layertree->InsertItem(str,TVI_ROOT,TVI_LAST);
	
	//Frame Length
	sprintf(str,"Frame Length = %d",framesize);
	layertree->InsertItem(str,layer1,TVI_LAST);

	
	layer2=layertree->InsertItem("Ethernet",TVI_ROOT,TVI_LAST);
	

	//Get Ethernet Header....
	eh=(eth_header*)frame;
	DisplayEthernetHeader(eh,NULL);

	//Get ARP header
	if(ntohs(eh->type)==0x0806)
	{
		layer3=layertree->InsertItem("ARP Layer",TVI_ROOT,TVI_LAST);
		DisplayARPHeader((arp_header*) (frame+ETHER_LENGTH) ,NULL);
	return;
	}
	
	//Reject frames other than IP/ARP frames....
	if(ntohs(eh->type)!=0x0800)
	return;

	
	//Get Internet Header
	layer3=layertree->InsertItem("IP Layer",TVI_ROOT,TVI_LAST);
	iph=(ip_header*)(frame+ETHER_LENGTH);
	DisplayIPHeader(iph,NULL);


	//Get the length of IP Header
	ip_hlen=(iph->ver_ihl & 0xf)<<2;
	
	switch(iph->proto)
	{
		case 1: //ICMP
			layer4=layertree->InsertItem("ICMP Layer",TVI_ROOT,TVI_LAST);
			icmph=(icmp_header*)(frame+ETHER_LENGTH+ip_hlen);
			DisplayICMPHeader(icmph,NULL);	
			dataoff=ETHER_LENGTH+ip_hlen+ICMP_LENGTH;
			datasize=framesize-dataoff;
		break;
		
		case 2: //IGMP
			layer4=layertree->InsertItem("IGMP Layer",TVI_ROOT,TVI_LAST);
			igmph=(igmp_header*)(frame+ETHER_LENGTH+ip_hlen);
			DisplayIGMPHeader(igmph,NULL);	
			dataoff=ETHER_LENGTH+ip_hlen+IGMP_LENGTH;
			datasize=framesize-dataoff;
		break;
		
	

		case 6: //TCP
			layer4=layertree->InsertItem("TCP Layer",TVI_ROOT,TVI_LAST);
			tcph=(tcp_header*)(frame+ETHER_LENGTH+ip_hlen);
			DisplayTCPHeader(tcph,NULL);	
			dataoff=ETHER_LENGTH+ip_hlen+TCP_LENGTH;
			datasize=framesize-dataoff;

		break;

		case 17: //UDP
			layer4=layertree->InsertItem("UDP Layer",TVI_ROOT,TVI_LAST);
			udph=(udp_header*)(frame+ETHER_LENGTH+ip_hlen);
			DisplayUDPHeader(udph,NULL);
			dataoff=ETHER_LENGTH+ip_hlen+UDP_LENGTH;
			datasize=framesize-dataoff;
		break;

		default:
			layer4=layertree->InsertItem("Unknown Protocol",TVI_ROOT,TVI_LAST);
			dataoff=ETHER_LENGTH+ip_hlen;
			datasize=framesize-dataoff;
		
		}

	if(datasize==0)
	return;
	
	//Display Data 
	layer5=layertree->InsertItem("Data Layer",TVI_ROOT,TVI_LAST);
	sprintf(str,"Data length = %d ",datasize);
	layertree->InsertItem(str,layer5,TVI_LAST);
	
}




void CCapturePacketDlg::DisplayEthernetHeader(eth_header *eh,CStdioFile *tfile)
{
int i;
char str[3][100],mac[100];
char file[500];	
	
	
	//Destination MAC address
	sprintf(str[0],"Dest Mac = ");
	for(i=0;i<6;i++)
	{
	sprintf(mac,"%.2x ",eh->dmac[i]);
	strcat(str[0],mac);
	}			
	
	//Source MAC Address
	sprintf(str[1],"Source  Mac = ");
	for(i=0;i<6;i++)
	{
	sprintf(mac,"%.2x ",eh->smac[i]);
	strcat(str[1],mac);
	}			
	
	
	
	//Ethernet Frame type
	if(ntohs(eh->type)==0x0800)  //IP
	sprintf(str[2],"Type = DOD/IP");
	else if(ntohs(eh->type)==0x0806)
		sprintf(str[2],"Type = ARP");
		else
		sprintf(str[2],"Type = Unknown");
		
	//Add to tree control
	if(tfile==NULL)
	{
		for(int i=0;i<3;i++)
		layertree->InsertItem(str[i],layer2,TVI_LAST);
	}
	else //write to file
	{
		sprintf(file,"%s\r\n%s\r\n%s",str[0],str[1],str[2]);
		tfile->WriteString(file);
	}
	

}



void CCapturePacketDlg::DisplayARPHeader(arp_header *arph,CStdioFile *tfile)
{
char str[4][100],file[300];

		//Information
		sprintf(str[0],"Length = 28");
		
		switch(ntohs(arph->opcode))
		{
			case 0x0001:
			sprintf(str[1],"ARP Request frame");
			break;
			case 0x0002:
			sprintf(str[1],"ARP Reply frame");
			break;
			case 0x0003:
			sprintf(str[1],"RARP Request frame");
			break;
			case 0x0004:
			sprintf(str[1],"RARP Reply frame");
			break;
			default:
			sprintf(str[1],"Unknown ARP");
		}
	
	

		//Get src and destination ip address
		sprintf(str[2],"Src IP = %d.%d.%d.%d",
				arph->saddr.byte1,
				arph->saddr.byte2,
				arph->saddr.byte3,
				arph->saddr.byte4);
	
		sprintf(str[3],"Dest IP= %d.%d.%d.%d",
				arph->daddr.byte1,
				arph->daddr.byte2,
				arph->daddr.byte3,
				arph->daddr.byte4);
	
		if(tfile==NULL)
		{
			for(int i=0;i<4;i++)
			layertree->InsertItem(str[i],layer3,TVI_LAST);
		}
		else
		{
		sprintf(file,"%s\r\n%s\r\n%s\r\n%s",str[0],str[1],str[2],str[3]);
		tfile->WriteString(file);
		}
		
}


void CCapturePacketDlg::DisplayIPHeader(ip_header *iph,CStdioFile *tfile)
{
char str[7][100],file[600];
	
	//Length
	sprintf(str[0],"Length = %d",(iph->ver_ihl & 0xf)<<2);
	
	//type of service
	sprintf(str[1],"Service = %x",iph->tos);
	
	//Identification
	sprintf(str[2],"ID = %d",iph->identification);
	
	//TTL 
	sprintf(str[3],"TTL  = %d",iph->ttl);
	
	//Checksum 
	sprintf(str[4],"Checksum  = %d",iph->crc);
	
	//Source  IP Address
	sprintf(str[5],"Src = %d.%d.%d.%d",iph->saddr.byte1,iph->saddr.byte2,iph->saddr.byte3,iph->saddr.byte4);
	
	//Destination IP Address
	sprintf(str[6],"Dest = %d.%d.%d.%d",iph->daddr.byte1,iph->daddr.byte2,iph->daddr.byte3,iph->daddr.byte4);
	
	if(tfile==NULL)
	{
		for(int i=0;i<7;i++)
		layertree->InsertItem(str[i],layer3,TVI_LAST);
	}
	else
	{
	sprintf(file,"%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s",str[0],str[1],str[2],str[3],str[4],str[5],str[6]);
	tfile->WriteString(file);
	}

}






void CCapturePacketDlg::DisplayTCPHeader(tcp_header *tcph,CStdioFile *tfile)
{
char str[7][100],file[500];
char tcpflag[8][10]={"FIN ","SYN ","RST ","PUSH ","ACK ","URG ","ECE ","CWR "};


	//Source port 
	sprintf(str[0],"Source Port = %d",ntohs(tcph->sport));
	
	//destination port
	sprintf(str[1],"Dest Port = %d",ntohs(tcph->dport));
	
	//Sequence No
	sprintf(str[2],"Seq No = %ul ",ntohl(tcph->seqno));
	
	//ACK  No
	sprintf(str[3],"ACK No = %ul ",ntohl(tcph->ackno));
	
	//Window
	sprintf(str[4],"Win Size = %d ",ntohs(tcph->win));
	
	//Checksum
	sprintf(str[5],"Checksum = %d ",tcph->checksum);
	
	
	
		//Each TCP mesg may contain more than one flag set...
	sprintf(str[6],"Type = ");		
		for(int i=0;i<8;i++)
		{
		if(tcph->flag & 1<<i)
		strcat(str[6],tcpflag[i]);
		}
		
	if(tfile==NULL)
	{
		for(int i=0;i<7;i++)
		layertree->InsertItem(str[i],layer4,TVI_LAST);
	}
	else
	{
	sprintf(file,"%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s\r\n%s",str[0],str[1],str[2],str[3],str[4],str[5],str[6]);
	tfile->WriteString(file);
	}

		
}






void CCapturePacketDlg::DisplayUDPHeader(udp_header *udph,CStdioFile *tfile)
{
char str[4][100],file[400];
	
	//Length
	sprintf(str[0],"Length = %d",UDP_LENGTH);
	
	//Source port 
	sprintf(str[1],"Source Port = %d",ntohs(udph->sport));
	
	//destination port
	sprintf(str[2],"Dest Port = %d",ntohs(udph->dport));
	
	//checksum
	sprintf(str[3],"Checksum = %d",udph->crc);
	

	if(tfile==NULL)
	{
		for(int i=0;i<4;i++)
		layertree->InsertItem(str[i],layer4,TVI_LAST);
	}
	else
	{
	sprintf(file,"%s\r\n%s\r\n%s\r\n%s",str[0],str[1],str[2],str[3]);
	tfile->WriteString(file);
	}


}







void CCapturePacketDlg::DisplayICMPHeader(icmp_header *icmph,CStdioFile *tfile)
{
char str[5][100],file[500];
int mesglen=16;
icmp_mesg mesg[]={  { 0, "Echo Reply"},
					{ 3, "Destination Unreachable"},
					{ 4, "Source Quench"},
					{ 5, "Redirect Message"},
					{ 6, "Alternate Host Address"},
					{ 8, "Echo Request"},
					{ 9, "Router Advertisement"},
					{ 10, "Router  Selection"},
					{ 11, "Time Exceeded"},
					{ 12, "Parameter Problem"},
					{ 13, "Timestamp Request"},
					{ 14, "Timestamp Reply"},
					{ 15, "Information Request"},
					{ 16, "Information Reply"},
					{ 17, "Address Mask Request"},
					{ 18, "Address Mask Reply"},
					
				};
	int i;
	for(i=0;i<mesglen;i++)
	{
		if(icmph->type==mesg[i].type)
		{
			sprintf(str[0],"%s",mesg[i].mesg);  //type
			break;
		}
	}
	if(i==mesglen)  //not found
	sprintf(str[0],"ICMP Unknown Message");

	
	sprintf(str[1],"Type = %d",icmph->type);  //type
	sprintf(str[2],"Code = %d",icmph->code);  //code
	sprintf(str[3],"ID = %d",icmph->id);      //id
	sprintf(str[4],"Seq No = %d",icmph->seqno); ///seqno
		
	if(tfile==NULL)
	{
		for(int i=0;i<5;i++)
		layertree->InsertItem(str[i],layer4,TVI_LAST);
	}
	else
	{
	sprintf(file,"%s\r\n%s\r\n%s\r\n%s\r\n%s",str[0],str[1],str[2],str[3],str[5]);
	tfile->WriteString(file);
	}
}


void CCapturePacketDlg::DisplayIGMPHeader(igmp_header *igmph,CStdioFile *tfile)
{
igmp_mesg groupmesg[13]={      
		{ 0x11 ," Group Membership Query."},
		{0x12 ,"IGMPv1 Membership Report." },
		{0x13 ,"DVMRP. "},
		{0x14 ,"PIMv1. "},
		{0x15 ,"Cisco Trace Messages. "},
		{0x16 ,"IGMPv2 Membership Report. "},
		{0x17 ,"IGMPv2 Leave Group." },
		{0x1E ,"Multicast Traceroute Response. "},
		{0x1F ,"Multicast Traceroute. "},
		{0x22 ,"IGMPv3 Membership Report. "},
		{0x24 ,"Multicast Router Advertisement. "},
		{0x25 ,"Multicast Router Solicitation. "},
		{0x26 ,"Multicast Router Termination. "}
				};
int igmp_mesglen=13;	
char str[5][100],file[400];


	int i;
	for(i=0;i<igmp_mesglen;i++)
	{
		if(groupmesg[i].type==igmph->type)
		{
		sprintf(str[0],"%s",groupmesg[0].mesg);
		break;
		}
	}
	
	//if it is not standard mesg...
	if(i==igmp_mesglen)
	sprintf(str[0],"IGMP General Message");
	
	sprintf(str[1],"Type = %d",igmph->type); //Type 
	sprintf(str[2],"Response Time = %d",igmph->restime); //Code
	sprintf(str[3],"Checksum = %d",igmph->checksum);//id
	//Multicast  Group  Address
	sprintf(str[4],"Group Addr = %d.%d.%d.%d",igmph->groupaddr.byte1,igmph->groupaddr.byte2,igmph->groupaddr.byte3,igmph->groupaddr.byte4);
				
	if(tfile==NULL)
	{
		for(int i=0;i<5;i++)
		layertree->InsertItem(str[i],layer4,TVI_LAST);
	}
	else
	{
	sprintf(file,"%s\r\n%s\r\n%s\r\n%s\r\n%s",str[0],str[1],str[2],str[3],str[4]);
	tfile->WriteString(file);
	}

}



