//////////////////////////////////////////////////////////////////////////////
//
//   WinSniff 1.1
//   The sniffing tool for windows.
//
//   Author  : Nagareshwar Y Talekar.
//	 Contact : nsry2002@yahoo.co.in
//	 Date    : 15-6-2004.
//
//   Name :  FPort.cpp
//   Description :  Displays dialog box for filtering the packet by Port
//
//////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "CapturePacket.h"
#include "FPort.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// FPort dialog


FPort::FPort(CWnd* pParent /*=NULL*/)
	: CDialog(FPort::IDD, pParent)
{
	
	IsEnable=FALSE;
	portno=8080;
	radioid=IDC_RADIO3;
	//{{AFX_DATA_INIT(FPort)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void FPort::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(FPort)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BOOL FPort::OnInitDialog()
{

	check=(CButton*)GetDlgItem(IDC_CHECK1);	
	port=(CEdit*)GetDlgItem(IDC_EDIT1);
	spin=(CSpinButtonCtrl*)GetDlgItem(IDC_SPIN1);
	

	rad1=(CButton*) GetDlgItem(IDC_RADIO1);
	rad2=(CButton*) GetDlgItem(IDC_RADIO2);
	rad3=(CButton*) GetDlgItem(IDC_RADIO3);
	rad4=(CButton*) GetDlgItem(IDC_RADIO4);
	
	CheckRadioButton(IDC_RADIO1,IDC_RADIO4,radioid);

	spin->SetBuddy(port);
	spin->SetRange32(1,65535);
	spin->SetPos(portno);
	
	check->SetCheck(IsEnable?1:0);

	IsEnable=~IsEnable; //adjustment..
	OnCheck();
	
	IsFirst=IsEnable;
	
	
	return CDialog::OnInitDialog();


}

BEGIN_MESSAGE_MAP(FPort, CDialog)
	ON_COMMAND(IDC_CHECK1,OnCheck)
		
//{{AFX_MSG_MAP(FPort)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// FPort message handlers


void FPort::OnCheck()
{
IsEnable=~IsEnable;

port->EnableWindow(IsEnable);
spin->EnableWindow(IsEnable);
rad1->EnableWindow(IsEnable);
rad2->EnableWindow(IsEnable);
rad3->EnableWindow(IsEnable);
rad4->EnableWindow(IsEnable);



}





void FPort::OnOK() 
{
	
		if(IsEnable)
		{
			portno=GetDlgItemInt(IDC_EDIT1);
		
			if(rad1->GetCheck()==1)
			{
				sprintf(portfilter," src port %d ",portno);
				radioid=IDC_RADIO1;
			}
		
			if(rad2->GetCheck()==1)
			{
				sprintf(portfilter," dst port %d ",portno);
				radioid=IDC_RADIO2;
			}
			
			if(rad3->GetCheck()==1)
			{
				sprintf(portfilter," src or dst port %d ",portno);
			    radioid=IDC_RADIO3;
			}
			
			
			if(rad4->GetCheck()==1)
			{
				sprintf(portfilter," src and dst port %d ",portno);
				radioid=IDC_RADIO4;
			}
		}
		else
		portfilter[0]=0;

CDialog::OnOK();


}




void FPort::OnCancel() 
{
	//Restore the status..
	IsEnable=IsFirst;
	CDialog::OnCancel();
}
