//////////////////////////////////////////////////////////////////////////////
//
//   WinSniff 1.1
//   The sniffing tool for windows.
//
//   Author  : Nagareshwar Y Talekar.
//	 Contact : nsry2002@yahoo.co.in
//	 Date    : 15-6-2004.
//
//   Name :  CapturePacketDlg.h
//   Description :  Main dialog of the application
//
//////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_CAPTUREPACKETDLG_H__EEF0DEE6_1BC5_11D8_888B_000B2B0F84B6__INCLUDED_)
#define AFX_CAPTUREPACKETDLG_H__EEF0DEE6_1BC5_11D8_888B_000B2B0F84B6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include<pcap.h>
#include "Protocol.h"
#include "Sniffer.h"
#include "FProtocol.h"
#include "FPort.h"
#include "FIPAddress.h"
#include "FCustom.h"



//int maximum no of packets...
#define MAX_PACKET 10000
#define MAX_PACKET_SIZE 2000

/////////////////////////////////////////////////////////////////////////////
// CCapturePacketDlg dialog

	//void packet_handler(u_char *param,const struct pcap_pkthdr *header,const u_char *pktdata);



class CCapturePacketDlg : public CDialog
{
// Construction
public:
	
	
	CCapturePacketDlg(CWnd* pParent = NULL);	// standard constructor

	
// Dialog Data
	//{{AFX_DATA(CCapturePacketDlg)
	enum { IDD = IDD_CAPTUREPACKET_DIALOG };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCapturePacketDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
	public:
	HICON m_hIcon;
	CListCtrl *list;
	CListBox  *datalist;
	CTreeCtrl *layertree;
	CMenu *menu;
	CFont datafont;
	CStdioFile *sfile;
	CToolTipCtrl treetip;
	BOOL IsProtocol,IsPort,IsIPAddress,IsVisible;
	CString filter,protofilter,portfilter,ipfilter,custfilter;
	int m_hotkeyid;

	HTREEITEM layer1,layer2,layer3,layer4,layer5;
	u_char frame[MAX_PACKET_SIZE];
	int framesize;
	int frameno,datasize,dataoff;
	Sniffer *sniff;
	FProtocol *fprotocol;
	FPort *fport;
	FIPAddress *fipaddress;
	FCustom  *fcustom;





	int packetcount;
	//For MAX_PACKET no of packets....
	int packetlength[MAX_PACKET];


	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	virtual void OnCancel();
	afx_msg void OnRowSelect(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnTreeSelect(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg LRESULT OnHotkey(WPARAM wParam, LPARAM lParam);



	
	void InitListCtrl();

	void DisplayFrame(int index);
	void DisplayData(u_char *frame,int length);
	void DisplayTree();
	void DisplayEthernetHeader(eth_header *,CStdioFile *);
	void DisplayARPHeader(arp_header *,CStdioFile *);
	void DisplayIPHeader(ip_header *,CStdioFile *);
	void DisplayTCPHeader(tcp_header *,CStdioFile *);
	void DisplayUDPHeader(udp_header *,CStdioFile *);
	void DisplayICMPHeader(icmp_header*,CStdioFile *);
	void DisplayIGMPHeader(igmp_header *,CStdioFile *);

	
	//Menu Handler Functions..
	//File Menu
	void OnOpenFrame();
	void OnSaveFrame();
	void WriteToFile(CStdioFile *);

	//Capture Menu
	void OnStartCapture();
	void OnStopCapture();

	//Filter Menu
	void OnFilterProtocol();
	void OnFilterPort();
	void OnFilterIPAddress();
	void OnFilterCustom();


	//View menu
	void OnHide();

	//Help Menu
	void OnAbout();

	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CAPTUREPACKETDLG_H__EEF0DEE6_1BC5_11D8_888B_000B2B0F84B6__INCLUDED_)
