//////////////////////////////////////////////////////////////////////////////
//
//   WinSniff 1.1
//   The sniffing tool for windows.
//
//   Author  : Nagareshwar Y Talekar.
//	 Contact : nsry2002@yahoo.co.in
//	 Date    : 15-6-2004.
//
//   Name :  FIPAdderss.cpp
//   Description :  Displays dialog box for filtering the packet by IP Address.
//
//////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CapturePacket.h"
#include "FIPAddress.h"
#include <afxcmn.h>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// FIPAddress dialog


FIPAddress::FIPAddress(CWnd* pParent /*=NULL*/)
	: CDialog(FIPAddress::IDD, pParent)
{
		IsEnable=FALSE;
		byte1=byte2=byte3=byte4=0;
		radioid=IDC_RADIO3;
	//{{AFX_DATA_INIT(FIPAddress)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void FIPAddress::DoDataExchange(CDataExchange* pDX)
{

	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(FIPAddress)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(FIPAddress, CDialog)
ON_COMMAND(IDC_CHECK1,OnCheck)
		
	//{{AFX_MSG_MAP(FIPAddress)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// FIPAddress message handlers


BOOL FIPAddress::OnInitDialog()
{

	check=(CButton*)GetDlgItem(IDC_CHECK1);	
	ip=(CIPAddressCtrl*)GetDlgItem(IDC_IPADDRESS1);


	ip->SetAddress(byte1,byte2,byte3,byte4);

	rad1=(CButton*) GetDlgItem(IDC_RADIO1);
	rad2=(CButton*) GetDlgItem(IDC_RADIO2);
	rad3=(CButton*) GetDlgItem(IDC_RADIO3);
	rad4=(CButton*) GetDlgItem(IDC_RADIO4);

	CheckRadioButton(IDC_RADIO1,IDC_RADIO4,radioid);

	check->SetCheck(IsEnable?1:0);

	// Double negation is the origional value...
	IsEnable=~IsEnable;
	OnCheck();

	IsFirst=IsEnable;
	
	return CDialog::OnInitDialog();


}



void FIPAddress::OnCheck()
{
IsEnable=~IsEnable;

ip->EnableWindow(IsEnable);
rad1->EnableWindow(IsEnable);
rad2->EnableWindow(IsEnable);
rad3->EnableWindow(IsEnable);
rad4->EnableWindow(IsEnable);

}





void FIPAddress::OnOK() 
{


		
		if(IsEnable && ip->IsBlank()==FALSE)
		{
			
			ip->GetAddress(byte1,byte2,byte3,byte4);

			if(rad1->GetCheck()==1)
			{
				sprintf(ipfilter,"  src net %d.%d.%d.%d  ",byte1,byte2,byte3,byte4);
			radioid=IDC_RADIO1;
			}
			
			if(rad2->GetCheck()==1)
			{
				sprintf(ipfilter,"  dst net %d.%d.%d.%d  ",byte1,byte2,byte3,byte4);
				radioid=IDC_RADIO2;
			}
			
			
			if(rad3->GetCheck()==1)
			{
				sprintf(ipfilter,"  src or dst net %d.%d.%d.%d  ",byte1,byte2,byte3,byte4);
				radioid=IDC_RADIO3;
			}
			
			if(rad4->GetCheck()==1)
			{
				sprintf(ipfilter,"  src and dst net %d.%d.%d.%d  ",byte1,byte2,byte3,byte4);
				radioid=IDC_RADIO4;
			}
		}
		else
		ipfilter[0]=0;

CDialog::OnOK();


}



void FIPAddress::OnCancel() 
{
	//Restore the initial status..
	IsEnable=IsFirst;
	CDialog::OnCancel();
}
