//////////////////////////////////////////////////////////////////////////////
//
//   WinSniff 1.1
//   The sniffing tool for windows.
//
//   Author  : Nagareshwar Y Talekar.
//	 Contact : nsry2002@yahoo.co.in
//	 Date    : 15-6-2004.
//
//   Name :  Packet.cpp
//   Description :  Thread for capturing the packet and displaying content in
//					main window.
//////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "CapturePacket.h"
#include "Packet.h"
#include "Protocol.h"

#include "CapturePacketDlg.h"


#include <winsock2.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Packet

IMPLEMENT_DYNCREATE(Packet, CWinThread)

Packet::Packet(CDialog *dialog)
{
capdlg=dialog;
}

Packet::Packet()
{

}

Packet::~Packet()
{
}

BOOL Packet::InitInstance()
{
	  
	return TRUE;
}

int Packet::ExitInstance()
{
return CWinThread::ExitInstance();
}

BEGIN_MESSAGE_MAP(Packet, CWinThread)
ON_THREAD_MESSAGE(WM_PACKET_STARTCAPTURE, StartCapture)
ON_THREAD_MESSAGE(WM_PACKET_CLOSETHREAD, CloseThread)

END_MESSAGE_MAP()



/**
*      Start the capture process...
*
*/

void Packet::StartCapture(WPARAM wp,LPARAM lp)
{
int retvalue;
struct tm ltime;
ip_header *ih;
udp_header *uh;
tcp_header *th;
eth_header *eh;
arp_header *arph;
igmp_header *igmph;
icmp_header *icmph;


char time[100];
char str[300];
char source[20],dest[20];
char tcpflag[8][10]={"FIN ","SYN ","RST ","PUSH ","ACK ","URG ","ECE ","CWR "};
int index=0,ip_hlen,i;
u_short sport,dport;
int *pcount,*plength;
int mesglen=16;
icmp_mesg mesg[]={  { 0, "Echo Reply"},
					{ 3, "Destination Unreachable"},
					{ 4, "Source Quench"},
					{ 5, "Redirect Message"},
					{ 6, "Alternate Host Address"},
					{ 8, "Echo Request"},
					{ 9, "Router Advertisement"},
					{ 10, "Router  Selection"},
					{ 11, "Time Exceeded"},
					{ 12, "Parameter Problem"},
					{ 13, "Timestamp Request"},
					{ 14, "Timestamp Reply"},
					{ 15, "Information Request"},
					{ 16, "Information Reply"},
					{ 17, "Address Mask Request"},
					{ 18, "Address Mask Reply"},
					
				};


igmp_mesg groupmesg[13]={      
		{ 0x11 ," Group Membership Query."},
		{0x12 ,"IGMPv1 Membership Report." },
		{0x13 ,"DVMRP. "},
		{0x14 ,"PIMv1. "},
		{0x15 ,"Cisco Trace Messages. "},
		{0x16 ,"IGMPv2 Membership Report. "},
		{0x17 ,"IGMPv2 Leave Group." },
		{0x1E ,"Multicast Traceroute Response. "},
		{0x1F ,"Multicast Traceroute. "},
		{0x22 ,"IGMPv3 Membership Report. "},
		{0x24 ,"Multicast Router Advertisement. "},
		{0x25 ,"Multicast Router Solicitation. "},
		{0x26 ,"Multicast Router Termination. "}
				};
int igmp_mesglen=13;	


	hdev=(pcap_t*)lp;
	plist=((CCapturePacketDlg*)capdlg)->list;
	sfile=((CCapturePacketDlg*)capdlg)->sfile;
	pcount=&(((CCapturePacketDlg*)capdlg)->packetcount);
	plength=((CCapturePacketDlg*)capdlg)->packetlength;
	
	while(*pcount<MAX_PACKET)
	{
		
	retvalue=pcap_next_ex(hdev,&header,(const u_char**)&pkt_data);
	
	//Error occured during capture...
	if(retvalue<0)
	break;

	//timer elapsed....
	if(retvalue==0)
	continue;

	//if the packet length is greater than maximum 
	//packet size ...then discard it....
	if(header->caplen > MAX_PACKET_SIZE)
	continue;

      
	//Store the size information about current packet
	plength[*pcount]=header->caplen;
	index=*pcount;
	*pcount=*pcount+1;
	
	//Write to log file.....
	sfile->Write(pkt_data,header->caplen);
	sfile->Flush();


	 //Insert item into the CListCtrl of dialog box
	sprintf(str,"%d             ",index+1);
	plist->InsertItem(index,str,NULL);
	
	
	 // convert the timestamp to readable format 
    _localtime32_s(&ltime, &header->ts.tv_sec);
    strftime( time, sizeof(time) , "%H:%M:%S", &ltime);
    
	plist->SetItemText(index,1,time);
	
	//Length of Frame
	sprintf(str,"%d",header->caplen);
	plist->SetItemText(index,2,str);
	
	//Get Frame type
	eh=(eth_header*)pkt_data;
	
	if(ntohs(eh->type)==0x0800)  //IP
	plist->SetItemText(index,3,"DOD/IP");
	else 
	{
		if(ntohs(eh->type)==0x0806) //ARP
		plist->SetItemText(index,3,"ARP");
		else
		{
			plist->SetItemText(index,3,"Unknown");
			continue;
		}
	}
	
		
	//Handle ARP/RARP frame.......
	if(ntohs(eh->type)==0x0806)
	{
	arph=(arp_header*)(pkt_data+ETHER_LENGTH);
	
		//Get src and destination ip address

		sprintf(source,"%d.%d.%d.%d",
				arph->saddr.byte1,
				arph->saddr.byte2,
				arph->saddr.byte3,
				arph->saddr.byte4);

		sprintf(dest,"%d.%d.%d.%d",
				arph->daddr.byte1,
				arph->daddr.byte2,
				arph->daddr.byte3,
				arph->daddr.byte4);
		
		plist->SetItemText(index,5,source);
		plist->SetItemText(index,7,dest);
	
	
	
		//Information
		if(ntohs(arph->opcode)==0x0001)
		sprintf(str,"ARP Request frame");
		if(ntohs(arph->opcode)==0x0002)
		sprintf(str,"ARP Reply frame");
		if(ntohs(arph->opcode)==0x0003)
		sprintf(str,"RARP Request frame");
		if(ntohs(arph->opcode)==0x0002)
		sprintf(str,"RARP Reply frame");

		
		plist->SetItemText(index,9,str);
			
		continue;	
	}
	  
	
	  //Get IP Header...
   	  ih=(ip_header*)(pkt_data+ETHER_LENGTH);
	
		//Get src and destination ip address

		sprintf(source,"%d.%d.%d.%d",
				ih->saddr.byte1,
				ih->saddr.byte2,
				ih->saddr.byte3,
				ih->saddr.byte4);

		sprintf(dest,"%d.%d.%d.%d",
				ih->daddr.byte1,
				ih->daddr.byte2,
				ih->daddr.byte3,
				ih->daddr.byte4);
		
		plist->SetItemText(index,5,source);
		plist->SetItemText(index,7,dest);
	
		//Get the length of IP Header
		ip_hlen=(ih->ver_ihl & 0xf)<<2;
	
		
		switch(ih->proto)
		{
			
			case 6:  //TCP
			plist->SetItemText(index,4,"TCP");
			
			th=(tcp_header*)((u_char*)ih+ip_hlen);

			//Get the port information
			sport=ntohs(th->sport);
			dport=ntohs(th->dport);
		
			sprintf(str,"%d",sport);
			plist->SetItemText(index,6,str);
			sprintf(str,"%d",dport);
			plist->SetItemText(index,8,str);
	
			//Each tcp mesg may contain more than one flag set...
			for(i=0,str[0]=0;i<8;i++)
			{
			if(th->flag & 1<<i)
			strcat(str,tcpflag[i]);
			}
			//Information
			plist->SetItemText(index,9,str);
			break;

			case 17:  //UDP	
			plist->SetItemText(index,4,"UDP");
			uh=(udp_header*)((u_char*)ih+ip_hlen);
		
			//Get the port information
			sport=ntohs(uh->sport);
			dport=ntohs(uh->dport);
			sprintf(str,"%d",sport);
			plist->SetItemText(index,6,str);
			sprintf(str,"%d",dport);
			plist->SetItemText(index,8,str);
			break;		
			
			case 1: //ICMP
			icmph=(icmp_header*) ((u_char*)ih+ip_hlen);
			plist->SetItemText(index,4,"ICMP");
			
			for( i=0;i<mesglen;i++)
				{
					if(icmph->type==mesg[i].type)
					{
					plist->SetItemText(index,9,mesg[i].mesg);
					break;
					}
				}
				if(i==mesglen)  //not found
				plist->SetItemText(index,9,"ICMP Unknown Message");
				
			break;
	
			case 2: //IGMP
			plist->SetItemText(index,4,"IGMP");
			igmph=(igmp_header*) ((u_char*)ih+ip_hlen);
			
			for(i=0;i<igmp_mesglen;i++)
			{
				if(groupmesg[i].type==igmph->type)
				{
				plist->SetItemText(index,9,groupmesg[i].mesg);
				break;
				}
			}
			
			//if it is not standard mesg...
			if(i==igmp_mesglen)
			plist->SetItemText(index,9,"Group Specific Message");
			
			  break;
	

			default:
				sprintf(str,"%d",ih->proto);
				plist->SetItemText(index,4,str);
		}	
	
	
	}    //End of while loop
	
}


void Packet::CloseThread(WPARAM wp,LPARAM lp)
{
::PostQuitMessage(0);
}






