//////////////////////////////////////////////////////////////////////////////
//
//   WinSniff 1.1
//   The sniffing tool for windows.
//
//   Author  : Nagareshwar Y Talekar.
//	 Contact : nsry2002@yahoo.co.in
//	 Date    : 15-6-2004.
//
//   Name :  Packet.h
//   Description :  Thread to capture the packets.
//
//////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_PACKET_H__A2167241_1C49_11D8_888B_000B2B0F84B6__INCLUDED_)
#define AFX_PACKET_H__A2167241_1C49_11D8_888B_000B2B0F84B6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// Packet.h : header file
//
#include<pcap.h>
#include "Protocol.h"


#pragma comment(lib, "wpcap.lib")
#pragma comment(lib, "ws2_32.lib")

#define WM_PACKET_STARTCAPTURE WM_USER+400
#define WM_PACKET_CLOSETHREAD  WM_USER+410



/////////////////////////////////////////////////////////////////////////////
// Packet thread

class Packet : public CWinThread
{
	DECLARE_DYNCREATE(Packet)
public :
		pcap_t *hdev;
	struct pcap_pkthdr *header;
	u_char *pkt_data;
	CStdioFile *sfile;
	CDialog *capdlg;
	CListCtrl *plist;
	

	public:	
	
	Packet();
	Packet(CDialog *);           // protected constructor used by dynamic creation
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	afx_msg void StartCapture(WPARAM wp,LPARAM lp);
	afx_msg void CloseThread(WPARAM wp,LPARAM lp);
	
protected:
	virtual ~Packet();

	
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_PACKET_H__A2167241_1C49_11D8_888B_000B2B0F84B6__INCLUDED_)
