//////////////////////////////////////////////////////////////////////////////
//
//   WinSniff 1.1
//   The sniffing tool for windows.
//
//   Author  : Nagareshwar Y Talekar.
//	 Contact : nsry2002@yahoo.co.in
//	 Date    : 15-6-2004.
//
//   Name :  Protocol.h
//   Description :  Contains the structure of headers for identifying
//					the packet format.
//
//////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_PROTOCOL_H__EB74E7E1_5C98_11D6_888C_000B2B0F84B6__INCLUDED_)
#define AFX_PROTOCOL_H__EB74E7E1_5C98_11D6_888C_000B2B0F84B6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include<pcap.h>

//  define the tcp flags....
#define   TCP_FIN   0x01
#define   TCP_SYN   0x02
#define   TCP_RST   0x04
#define   TCP_PSH   0x08
#define   TCP_ACK   0x10
#define   TCP_URG   0x20
#define   TCP_ACE   0x40
#define   TCP_CWR   0x80


//define header lengths

#define ETHER_LENGTH 14
#define IP_LENGTH    20
#define TCP_LENGTH   20
#define UDP_LENGTH   8
#define ICMP_LENGTH  8
#define IGMP_LENGTH  8
#define ARP_LENGTH   28
#define IGMP_MESG_LENGTH 13

	// Ethernet Header
	struct eth_header   // 14 bytes
	{
	u_char dmac[6]; //destination mac address
	u_char smac[6]; //source mac address
	u_short type;                 //IP ,ARP , RARP
	};
	
	// IPV4 Address
	struct ip_address
	{
	u_char byte1;
	u_char byte2;
	u_char byte3;
	u_char byte4;
	};

	// ARP header
	struct arp_header   //28 bytes
	{
	u_short hrd;       //hardware address space=0x0001
	u_short eth_type;  //Ethernet type ....=0x0800
	u_char maclen;     //Length of mac address=6
	u_char iplen;      //Length of ip addres=4
	u_short opcode;    //Request =1 Reply=2 (highbyte)
	u_char smac[6];    //source mac address
	ip_address saddr;  //Source ip address
	u_char dmac[6];    //Destination mac address
	ip_address daddr;  //Destination ip address
	};
	
	typedef arp_header rarp_header;

	
	/* IPv4 header */
    struct ip_header
	{
	u_char  ver_ihl;        // Version (4 bits) + Internet header length (4 bits)
    u_char  tos;            // Type of service 
    u_short tlen;           // Total length 
    u_short identification; // Identification
    u_short flags_fo;       // Flags (3 bits) + Fragment offset (13 bits)
    u_char  ttl;            // Time to live
    u_char  proto;          // Protocol
    u_short crc;            // Header checksum
    ip_address  saddr;      // Source address
    ip_address  daddr;      // Destination address
   // u_int   op_pad;         // Option + Padding
	};

	// UDP header
   struct udp_header   //8 bytes
   {
    u_short sport;          // Source port
    u_short dport;          // Destination port
    u_short len;            // Datagram length
    u_short crc;            // Checksum
   };

   // TCP header
	struct tcp_header  //20 bytes : default
	{
	u_short sport;      //Source port
	u_short dport;      //Destination port
	u_long seqno;       //Sequence no
	u_long ackno;       //Ack no
	u_char offset;      //Higher level 4 bit indicates data offset
	u_char flag;        //Message flag
					//FIN - 0x01
					//SYN - 0x02
					//RST - 0x04 
					//PUSH- 0x08
					//ACK- 0x10
					//URG- 0x20
					//ACE- 0x40
					//CWR- 0x80

	u_short win;
	u_short checksum;
	u_short uptr;
  	};

	// ICMP Header
	struct icmp_header
	{
	u_char type;
	u_char code;
	u_short checksum;
	u_short id;
	u_short seqno;
	};


	//IGMP version 2 
	struct igmp_header
	{
	u_char type;         //type of igmp message
	u_char restime;      //Response time
	u_short checksum;    //checksum ...
	ip_address groupaddr; //Multicast Group Address
	};
	
	// Structure for storing IGMP messages.
	struct igmp_mesg
	{
	u_char type;
	char mesg[200];
	};

	// Structure for storing ICMP messages.
	struct icmp_mesg
	{
	u_char type;
	char mesg[200];
	};

#endif // !defined(AFX_PROTOCOL_H__EB74E7E1_5C98_11D6_888C_000B2B0F84B6__INCLUDED_)
