//////////////////////////////////////////////////////////////////////////////
//
//   WinSniff 1.1
//   The sniffing tool for windows.
//
//   Author  : Nagareshwar Y Talekar.
//	 Contact : nsry2002@yahoo.co.in
//	 Date    : 15-6-2004.
//
//   Name :  FProtocol.cpp
//   Description :  Displays dialog box for filtering the packet by protocol
//
//////////////////////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "CapturePacket.h"
#include "FProtocol.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// FProtocol dialog


FProtocol::FProtocol(CWnd* pParent /*=NULL*/)
	: CDialog(FProtocol::IDD, pParent)
{
	IsEnable=FALSE;
	selindex=0;
	//{{AFX_DATA_INIT(FProtocol)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void FProtocol::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(FProtocol)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(FProtocol, CDialog)
	ON_COMMAND(IDC_CHECK1,OnCheck)
	//{{AFX_MSG_MAP(FProtocol)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()




BOOL FProtocol::OnInitDialog()
{

	check=(CButton*)GetDlgItem(IDC_CHECK1);	
	plist=(CComboBox*)GetDlgItem(IDC_COMBO1);
	
	plist->SetWindowPos(&wndTop,0,0,120,120,SWP_SHOWWINDOW | SWP_NOMOVE);
	plist->ResetContent();
	plist->AddString("ICMP");
	plist->AddString("IGMP");
	plist->AddString("TCP");
	plist->AddString("UDP");
	plist->SetCurSel(0);
	
	check->SetCheck(IsEnable?1:0);
	plist->EnableWindow(IsEnable);
	
	plist->SetCurSel(selindex);

	
	IsFirst=IsEnable;
	
	return CDialog::OnInitDialog();
}

/////////////////////////////////////////////////////////////////////////////
// FProtocol message handlers


void FProtocol::OnCheck()
{
IsEnable=~IsEnable;

plist->EnableWindow(IsEnable);
}

void FProtocol::OnOK() 
{
		if(IsEnable)
		{
			selindex=plist->GetCurSel();
			plist->GetLBText(selindex,protocol);
			
			protocol.MakeLower();
		}
		else
		protocol="";
	
CDialog::OnOK();
}

void FProtocol::OnCancel() 
{

	//Restore the initial status....
	IsEnable=IsFirst;
	check->SetCheck(IsEnable?1:0);
	CDialog::OnCancel();
}
