//////////////////////////////////////////////////////////////////////////////
//
//   WinSniff 1.1
//   The sniffing tool for windows.
//
//   Author  : Nagareshwar Y Talekar.
//	 Contact : nsry2002@yahoo.co.in
//	 Date    : 15-6-2004.
//
//   Name :  Sniffer.cpp
//   Description :  Deals with capture packet device and starts
//					the capture process.
//
//////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CapturePacket.h"
#include "Sniffer.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif




Sniffer::Sniffer()
{

 
	
	/*log.Open("log.txt",CFile::modeCreate | CFile::modeReadWrite | CFile::shareDenyWrite);
	log.WriteString("This log file is generated by Sniffer");
	log.Flush();

	*/	
	isOpen=FALSE;
	isPause=FALSE;

	pause=0;

}



Sniffer::~Sniffer()
{

	//log.Close();

}


/**
*     Enumerate all available devices...
*
*/

int Sniffer::GetDeviceList()
{
int retvalue,i;
char err[PCAP_ERRBUF_SIZE];
pcap_if_t *d;

    devcount=0;


	retvalue=pcap_findalldevs(&devlist,err);
		
	if(retvalue==-1 || devlist==NULL)
	return FALSE;
 
	
	// Enumerate available devices...
	// Store the name and decription...
	for(d=devlist,i=0; d && i<10 ;d=d->next,i++)
    {
        devname[i]=d->name;
		description[i]=d->description;
			
	}

	devcount=i;

	return devcount;

}



BOOL Sniffer::OpenDevice(int index)
{
char err[PCAP_ERRBUF_SIZE];

    	
	// if the device is already open ..return
	if(isOpen==TRUE)
	return FALSE;
	
	
	hdev=pcap_open_live( LPCTSTR(devname[index]), //name of the device
		                 65536,   //size ->Capture whole packet
	                      1, //promiscous mode  
						  1000,  //read timeout
						  err );

	
	if(hdev==NULL)
	return FALSE;

	/*
	//check the link layer to support only ethernet
	if(pcap_datalink(hdev)!=DLT_EN10MB)
	{
	log.WriteString("\n Error : Only Ethernet Network is supported");
	return FALSE;
	}

	*/

	isOpen=TRUE;
	isStarted=FALSE;

return TRUE;

}


BOOL Sniffer::ApplyFilter(char *filter)
{

u_int netmask;
int retvalue;
char mesg[300]="\nApplying the filter ";
	
	//log.WriteString(strcat(mesg,filter));
	
	if(isOpen==FALSE)
	return FALSE;

	//Free the previous filter if already applied
	
	/*
	if(isFilter)
	{
	pcap_freecode(&fcode);
	}
	*/

	//log.WriteString(strcat(mesg,filter));
	
	if(devlist->addresses!=NULL)
	netmask=((struct sockaddr_in *)(devlist->addresses->netmask))->sin_addr.S_un.S_addr;
	else
	netmask=0xffffff;

	//compile the filter
	retvalue=pcap_compile(hdev,&fcode,filter,1,netmask);
	
	if(retvalue<0)
	{
	//log.WriteString("\n Unable to compile the filter");
	return FALSE;
	}

	//Set the filter
	retvalue=pcap_setfilter(hdev,&fcode);
	
	if(retvalue<0)
	{
	//log.WriteString("\n Unable to set the filter");
	return FALSE;
	}
	
	
	//log.WriteString("\n Filter applied successfully");

return TRUE;



}


/**
*    Start capturing packets....
*	 Before calling this OpenDevice() funtion must be called...
*/
void Sniffer::StartCapture(CDialog *dialog)
{
	
	if(isOpen==TRUE)
	{
		// Create and start the thread
		packet=new Packet(dialog);
		packet->CreateThread();
		packet->PostThreadMessage(WM_PACKET_STARTCAPTURE,0,(LPARAM)hdev);
		isStarted=TRUE;
	}

}



/**
*    Stop the capture
*
*/
void Sniffer::StopCapture()
{
	
	// If it is started ...then stop it
	if(isStarted)
	{
		isStarted=FALSE;
		packet->SuspendThread();
	
		// Close the thread...
		packet->PostThreadMessage(WM_PACKET_CLOSETHREAD,0,0);
		packet=NULL;
	}

	// Now close the device...
	if(isOpen)
	{
		pcap_freealldevs(devlist);
		pcap_close(hdev);
	
        isOpen=FALSE;
	}

	
}


void Sniffer::ResumeCapture()
{
	if(packet!=NULL)
	packet->ResumeThread();

}


void Sniffer::PauseCapture()
{
	if(packet!=NULL)
	packet->SuspendThread();

}




void Sniffer::CloseDevice()
{

	StopCapture();
	
}